unit Time;

//################################################
interface uses NTDLL, Kernel;
//################################################

const

	gt_Success = 0;
	gt_Unknown = 1;
	gt_Invalid = 2;

function GetIntTime(hFile:HANDLE; pBuff:PFILETIME) : INT32;

//################################################
implementation uses Utils;
//################################################

type

	TFileInfo = record
		hFile : HANDLE;
		Size : NAT32;
		p512B : POINTER;
	end;
	PFileInfo = ^TFileInfo;

function GetTime_PE(pFI:PFileInfo; pBuff:PFILETIME) : INT32; stdcall;
var
	tmp, offs : NAT32;
	buf : array [0..511] of BYTE;
	ptr : POINTER;
	fi : TFileInfo;
begin
	result:= gt_Unknown;
	fi:= pFI^;
	tmp:= PNAT16(fi.p512B)^;
	if (tmp <> $5A4D) then exit; // 'MZ'
	offs:= PIMAGE_DOS_HEADER(fi.p512B)^.e_lfanew;
	if (fi.Size < (offs + 4)) then exit;
	if (offs > 508) then begin
		SetFilePointer(fi.hFile, offs, NIL, $00);
		ReadFile(fi.hFile, @buf, 512, @tmp, NIL);
		ptr:= @buf;
	end else ptr:= POINTER(NAT32(fi.p512B) + offs);
	if (PIMAGE_NT_HEADERS32(ptr)^.Signature <> $4550) then exit; // PE
	tmp:= PIMAGE_NT_HEADERS32(ptr)^.FileHeader.TimeDateStamp;
	StampToTime(tmp, pBuff);
	if (tmp = $2A425E19) or (tmp = 0) then result:= gt_Invalid else result:= gt_Success;
//	$2A425E19 = 19/06/1992 22:22:17 (GMT+00:00)
end;

function GetTime_Lib(p512B:POINTER; pBuff:PFILETIME) : INT32;
var
	buf : array [0..10] of CHAR;
begin
	if (PNAT64(p512B)^ = $0A3E686372613C21) then begin // '!<arch>'#$0A
		CopyText(@buf, PCHAR(p512B) + 24, 10, ' ');
		StampToTime(DecToInt(@buf), pBuff);
		result:= gt_Success;
	end else result:= gt_Unknown;
end;

function GetIntTime;
var
	buf : array [0..511] of BYTE;
	tmp : NAT32;
	fi : TFileInfo;
begin
	fi.hFile:= hFile;
	fi.Size:= GetFileSize(hFile, NIL);
	fi.p512B:= @buf;
	ReadFile(hFile, @buf, 512, @tmp, NIL);
	result:= GetTime_PE(@fi, pBuff);
	if (result = gt_Unknown) then result:= GetTime_Lib(fi.p512B, pBuff);
end;

end.
